 ; Ŀ
 ;   Tlen - get the total length of heat trace lines in a drawing.         
 ;   Copyright 1999, 2002 by Rocket Software Ltd.                          
 ;   There is no communication protocol which uses compressed air.         
 ; 

 ; Ŀ
 ;   Subroutine Pwark - mark vertexes in a lwpline, return its length.     
 ; 
 (DEFUN PWARK (enam / esav rad totlen entt next pa pb)
  (setq esav enam)
  (setq rad (/ (getvar "viewsize") 50))
  (setq totlen 0)
  (setq entt (entget enam))
  (while (setq next (car entt))
         (setq entt (cdr entt))
         (if (= (car next) 10)
             (fark (cdr next) rad)))
  (setq entt (entget esav))
  (while (setq next (car entt))
         (setq entt (cdr entt))
         (if (= (car next) 10)
             (progn
                  (setq pa (cdr next))
                  (fark pa rad)
                  (if (and pa pb)
                      (setq totlen (+ totlen (distance pa pb))))
                  (setq pb pa))))
 totlen)
 ; Ŀ
 ;   Subroutine Pwark end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Fark - mark a point.                                       
 ; 
 (DEFUN FARK (pa rad)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) -1)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) -1)
  (grdraw (polar pa 0 rad) (polar pa pi rad) -1)
  (grdraw (polar pa (* pi 0.5) rad) (polar pa (* pi 1.5) rad) -1)
  (repeat 50 (expt pi 5))
 (princ))
 ; Ŀ
 ;   Subroutine Fark end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Phark - mark vertexes in a pline, return its length.       
 ; 
 (DEFUN PHARK (enam / esav entt pa pb totlen rad)
  (setq esav enam)
  (setq rad (/ (getvar "viewsize") 50))
  (setq totlen 0)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq esav (entnext esav)))))))
         (fark (cdr (assoc 10 entt)) rad))
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq pa (cdr (assoc 10 entt)))
         (fark pa rad)
         (if (and pa pb)
             (setq totlen (+ totlen (distance pa pb))))
         (setq pb pa))
 totlen)
 ; Ŀ
 ;   Subroutine Phark end.                                                 
 ; 

 ; Ŀ
 ;   Tlen.                                                                 
 ; 
 (DEFUN C:TLEN (/ ss num len enam)
  (prompt "Select Trace lines or <Return> for all: ")
  (if (setq ss (ssget (list (cons 8 "*htrace") '(-4 . "<or")
                            (cons 0 "polyline") (cons 0 "lwpolyline")
                            '(-4 . "or>"))))
      (setq totxt "Selected")
      (progn
           (setq ss (ssget "X" (list (cons 8 "*htrace") '(-4 . "<or")
                                     (cons 0 "polyline") (cons 0 "lwpolyline")
                                     '(-4 . "or>"))))
           (setq totxt "Total")))
  (setq num 0)
  (setq len 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (if (= (cdr (assoc 0 (entget enam))) "POLYLINE")
             (grtext -2 (rtos (setq len (+ len (phark enam))) 2 2))
             (grtext -2 (rtos (setq len (+ len (pwark enam))) 2 2))))
  (write-line (strcat totxt " HT Length: " (rtos (/ len 1000) 2 1) "M"))
 (princ))